package cn.com.duiba.oto.oto.service.api.remoteservice.wx;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.wx.WxUsersDto;

import java.util.List;
import java.util.Map;

/**
 * @author xiaotian
 * @date 2023/01/28
 */
@AdvancedFeignClient
public interface RemoteWxUsersService {

    /**
     * 批量插入用户基本信息
     */
    int batchInsert(List<WxUsersDto> userDtos);

    /**
     * 保存用户手机号
     *
     * @param dto
     * @return
     */
    Boolean updatePhoneNumber(WxUsersDto dto);

    /**
     * 根据id查询基本信息
     *
     * @param userId
     * @return
     */
    WxUsersDto selectById(Long userId);

    /**
     * 通过id列表批量查询用户
     *
     * @param ids
     * @return
     */
    List<WxUsersDto> findByIds(List<Long> ids);

    /**
     * 通过id列表批量查询用户
     *
     * @param ids
     * @return
     */
    Map<Long, WxUsersDto> findMapByIds(List<Long> ids);


    /**
     * 根据用户主键更新
     *
     * @param userDto
     * @return
     */
    Integer updateById(WxUsersDto userDto);


    /**
     * 根据unionIDs查询userID
     *
     * @param unionIds
     * @return
     */
    List<WxUsersDto> selectIdByUnionIds(List<String> unionIds);


    /**
     * 根据id删除用户
     *
     * @param userId
     * @return
     */
    boolean deleteById(Long userId);

}
