package cn.com.duiba.oto.enums.cust.ext;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-11 14:14
 */
@Getter
@AllArgsConstructor
public enum OtoCompanyEnum {

    TAI_BAO(2, "上海太保"),
    TAI_KANG(3, "杭州泰康"),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCompanyEnum::getType, OtoCompanyEnum::getDesc, (v1, v2)->v1)));

}
