package cn.com.duiba.oto.enums.form.customer;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 公域引流-用户管理来源枚举
 *
 * @author xiaocong
 * @date 2021/11/15 3:38 下午
 */
@AllArgsConstructor
@Getter
public enum PubFormCustomerSourceEnum {

    /**
     * 手动添加
     */
    MANUAL(0, "手动添加"),

    /**
     * 自动同步
     */

    AUTO(1, "自动同步");

    /**
     * code码
     */
    private final Integer code;

    /**
     * 信息
     */
    private final String desc;

    public static final Map<Integer, String> SOURCE_MAP;

    static {
        Map<Integer, String> map = Arrays.stream(values()).collect(Collectors.toMap(PubFormCustomerSourceEnum::getCode, PubFormCustomerSourceEnum::getDesc));
        SOURCE_MAP = Collections.unmodifiableMap(map);
    }
}
