package cn.com.duiba.oto.dto.oto.wxwork;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 企微消息记录信息表
 * @author kjj mybatis generator 
 * @date 2022-10-08
 */
@Data
public class OtoMsgDto implements Serializable {
     
    private static final long serialVersionUID = 16651976943873692L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 会话ID=内部userkey+外部userkey 如果是群聊=roomid
     */
    private String chatId;

    /**
     * 消息ID,消息的唯一标识，企业可以使用此字段进行消息去重
     */
    private String msgId;

    private Long seq;

    /**
     * 消息动作，目前有send(发送消息)/recall(撤回消息)/switch(切换企业日志)三种类型
     */
    private String msgAction;

    /**
     * 消息发送方id，同一企业内容为userid，非相同企业为external_userid。消息如果是机器人发出，也为external_userid
     */
    private String fromUserKey;

    /**
     * 消息发送方名字
     */
    private String fromUserName;

    /**
     * 消息接收方（集合），同一个企业内容为userid，非相同企业为external_userid
     */
    private String receiveUserKey;

    /**
     * 消息接受方名字
     */
    private String reveiveUserName;

    /**
     * 群聊消息的群id
     */
    private String roomid;

    /**
     * 群聊消息群名称
     */
    private String roomName;

    /**
     * 会话类型 1 内部单聊 2 内部群聊 3 外部单聊 4 外部群聊
     */
    private Integer convType;

    /**
     * 消息发送，utc时间，ms单位
     */
    private Date msgtime;

    /**
     * 文本消息为：text
     */
    private String msgtype;

    /**
     * 消息内容（只存会话消息） 如果是图片，则该字段为空
     */
    private String content;

    /**
     * 消息内容(json格式 ，比如消息内容为图片，存储图片的大小等参数)
     */
    private String contentJson;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
}