package cn.com.duiba.oto.enums.callback;

import cn.com.duiba.kjy.base.api.utils.NumberUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-07-20 16:08
 */
@Getter
@AllArgsConstructor
public enum CLueCallbackReasonEnum {

    NOT_EXIST_PHONE_NUM(1, "空号客户"),
    LONG_TIME_REFUSE_CALL(2, "长时间未拨通"),
    INTERVIEW_SUCCESS(3, "约面成功"),
    ;

    /**
     * 类型
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, CLueCallbackReasonEnum> ENUM_MAP = Arrays.stream(values()).collect(Collectors.toMap(CLueCallbackReasonEnum::getType, Function.identity(), (v1, v2) -> v1));

    public static CLueCallbackReasonEnum getByType(Integer type){
        if (NumberUtil.isNullOrLteZero(type)) {
            return null;
        }
        return ENUM_MAP.get(type);
    }
}
