package cn.com.duiba.oto.enums.cust.ext;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.collections.CollectionUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-06 14:39
 * 客户核心决策人枚举
 */
@Getter
@AllArgsConstructor
public enum OtoCustCoreMakerEnum {

    UN_KNOW(1, "不明或其他"),
    SELF(2, "自己"),
    MATE(3, "配偶"),
    CHILDREN(4, "子女"),
    PARENT(5, "父母");


    private final Integer type;

    private final String desc;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustCoreMakerEnum::getType, OtoCustCoreMakerEnum::getDesc, (v1, v2)->v1)));

    /**
     * 根据类型获取描述
     */
    public static String getDescByType(Integer type){
        if (type == null) {
            return null;
        }
        return ALL_MAP.get(type);
    }

    /**
     * 根据类型获取描述
     */
    public static String getDescByTypes(List<Integer> types){
        if (CollectionUtils.isEmpty(types)) {
            return null;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < types.size(); i++) {
            if(i == types.size()-1){
                builder.append(ALL_MAP.get(types.get(i)));
            }else{
                builder.append(ALL_MAP.get(types.get(i))).append(",");
            }
        }
        return builder.toString();
    }
}
