package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.CustSourceExtDto;

import java.util.Date;
import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-05-30 10:04
 */
@AdvancedFeignClient
public interface RemoteCustSourceExtService {

    /**
     * 新增
     * @param dto 客户来源
     * @return 执行结果
     */
    boolean insert(CustSourceExtDto dto);

    /**
     * 批量插入客户来源
     * @param list 客户来源
     * @return 执行结果
     */
    boolean batchInsert(List<CustSourceExtDto> list);

    /**
     * 根据客户id获取sourceExt
     * @param custIds 客户id
     * @return 客户来源ext
     */
    List<CustSourceExtDto> listByCustIds(List<Long> custIds);

    /**
     * 统计允许赔付的数据
     * @param beginDate 开始日期
     * @return 允许赔付的数据数量
     */
    Long countEnablePaidNum(Date beginDate);
}
