package cn.com.duiba.oto.oto.service.api.remoteservice.seller;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.seller.SellerTaskConfDto;
import cn.com.duiba.oto.dto.oto.seller.SellerTaskConfV2Dto;
import cn.com.duiba.oto.dto.oto.seller.SellerTaskDetailDto;
import cn.com.duiba.oto.dto.oto.seller.SellerTaskDetailV2Dto;
import cn.com.duiba.oto.dto.oto.seller.SellerTodayTaskInfoDto;
import cn.com.duiba.oto.param.oto.seller.SellerTaskConfParam;
import cn.com.duiba.oto.param.oto.seller.SellerTaskConfV2Param;

import java.util.List;

/**
 * oto-销售任务
 *
 * @author chenzhenxing
 * @date 2022/4/24 1:45 下午
 */
@AdvancedFeignClient
public interface RemoteOtoSellerTaskV2Service {
    /**
     * 获取销售当天任务
     *
     * @param sellerId 销售id
     * @return 当天任务信息
     */
    List<SellerTodayTaskInfoDto> getTodayTaskInfo(Long sellerId);

    /**
     * 获取销售当日任务详情信息
     *
     * @param sellerId   销售id
     * @param taskConfId 任务配置项id
     * @return 任务详情信息
     */
    List<SellerTaskDetailV2Dto> findTodaySellerTaskDetail(Long sellerId, Long taskConfId);

    /**
     * 查询全部任务配置
     *
     * @return 任务配置
     */
    List<SellerTaskConfV2Dto> getAllTaskConf();

    /**
     * 更新任务配置
     *
     * @param param 任务配置信息
     * @return 修改结果
     */
    boolean modifyTaskConf(SellerTaskConfV2Param param);

    /**
     * 根据id获取任务配置
     *
     * @param id 主键
     * @return 任务配置
     */
    SellerTaskConfV2Dto findTaskConfById(Long id);

    /**
     * 根据客户状态 查询任务配置
     *
     * @return 任务配置集合
     */
    SellerTaskConfV2Dto findSellerTaskConf(Integer custConfStatus);
}
