package cn.com.duiba.oto.param.oto.cust;

import cn.com.duiba.oto.param.oto.common.PageQuery;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.util.Date;
import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-11 17:22
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ToString(callSuper = true)
public class OtoCustomerSearchParam extends PageQuery {

    private static final long serialVersionUID = 2169640864944182855L;

    /**
     * 是否为星标客户
     */
    private Integer custStar;

    /**
     * 销售id
     */
    private Long otoSid;

    /**
     * 排序类型
     *
     * @see cn.com.duiba.oto.enums.cust.OtoCustSortTypeEnum
     */
    private String sortType;

    /**
     * 客户分类枚举
     * @see cn.com.duiba.oto.enums.cust.follow.OtoCustClassifyEnum
     */
    private Integer custClassifyType;

    /**
     * 客户价值
     * @see cn.com.duiba.oto.enums.cust.ext.OtoCustValueEnum
     * @deprecated 使用 {@link #custValues}
     */
    @Deprecated
    private Integer custValue;

    /**
     * 客户价值, 英文逗号分隔
     * @see cn.com.duiba.oto.enums.cust.ext.OtoCustValueEnum
     */
    private List<Integer> custValues;

    /**
     * 跟进状态
     * @see cn.com.duiba.oto.enums.cust.follow.OtoCustFollowStatusEnum
     */
    private Integer followStatus;

    /**
     * 标签id
     * @deprecated 使用 {@link #tagIds}
     */
    @Deprecated
    private Long tagId;

    /**
     * 标签id
     */
    private List<Long> tagIds;

    /**
     * 关注度
     *
     * @see cn.com.duiba.oto.enums.cust.follow.OtoCustFollowWeightEnum
     */
    private List<Integer> followWeights;

    /**
     * 分配类型
     *
     * @see cn.com.duiba.oto.enums.cust.follow.OtoCustAssignTypeEnum
     */
    private List<Integer> assignTypes;

    /**
     * 分配起始时间
     */
    private Date assignBeginTime;

    /**
     * 分配结束时间
     */
    private Date assignEndTime;

    /**
     * 跟进起始时间
     */
    private Date followBeginTime;

    /**
     * 跟进结束时间
     */
    private Date followEndTime;

    /**
     * 客户姓名
     */
    private String custName;

    /**
     * 流程组状态
     * @see cn.com.duiba.oto.enums.cust.CustFlowEnum
     */
    private Integer custFlow;

    /**
     * 客户来源
     * @see cn.com.duiba.oto.enums.cust.CustSourceEnum
     */
    private List<Integer> custSources;

    /**
     * 行为类型，用，隔开
     */
    private List<String> custActionTypeList;

    /**
     * 客户地区
     */
    private List<String> custAreas;

    private List<Long> custIds;

    /**
     * 是否接通 0否 1是 只要客户打通过一次就算接通
     */
    private Integer callStatus;

    /**
     * 是否约到一面 0否 1是
     */
    private Integer firstInterviewFlag;

    /**
     * 约见时间-开始
     */
    private String interviewBeginTime;

    /**
     * 约见时间-结束
     */
    private String interviewEndTime;

    /**
     * 加微状态
     */
    private Integer addWxStatus;
}
