package cn.com.duiba.oto.param.oto.cust.cust.visit;

import lombok.Data;

import java.io.Serializable;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-14 14:10
 */
@Data
public class CustMeetRecordSaveParam implements Serializable {

    private static final long serialVersionUID = 8186892225289816357L;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 销售id
     */
    private Long sellerId;

    /**
     * 提交方案后客户状态
     *
     * @see cn.com.duiba.oto.enums.cust.visit.OtoCustCommitStatusEnum
     */
    private Integer commitCustStatus;

    /**
     * 是否提交养老规划方案
     */
    private Integer commitPlanFlag;

    /**
     * 面访备注
     */
    private String meetRemark;

    /**
     * 客户价值
     * @see cn.com.duiba.oto.enums.cust.ext.OtoCustValueEnum
     */
    private Integer custValue;

    /**
     * 关注度
     * @see cn.com.duiba.oto.enums.cust.follow.OtoCustFollowWeightEnum
     */
    private Integer followWeight;

    /**
     * 销售评价类型
     * @see cn.com.duiba.oto.enums.OtoCommentTypeEnum
     */
    private Integer commentType;

    /**
     * 评价备注
     * @see cn.com.duiba.oto.enums.log.CustCommonLogKeyEnum
     */
    private String commentRemark;
}
