/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.cust;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum BooleanEnum {
    NO(0, "\u5426"),
    YES(1, "\u662f");

    private static final Map<Integer, BooleanEnum> INNER_MAP;
    private final Integer code;
    private final String desc;

    private BooleanEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static BooleanEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code) {
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        INNER_MAP = Collections.unmodifiableMap(Arrays.stream(BooleanEnum.values()).collect(Collectors.toMap(BooleanEnum::getCode, Function.identity(), (v1, v2) -> v1)));
    }
}

