package cn.com.duiba.oto.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 销售账号状态枚举
 *
 * @author ZhangJun
 * @date 2022/1/7 5:30 下午
 */
@Getter
@AllArgsConstructor
public enum OtoSellerStatusEnum {

    /**
     * 禁用
     */
    DISABLE(0, "禁用"),

    /**
     * 启用
     */
    ENABLE(1, "启用"),
    ;

    private Integer sellerStatus;
    private String desc;

    private static final Map<Integer, OtoSellerStatusEnum> ENUM_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoSellerStatusEnum::getSellerStatus, Function.identity(), (v1, v2) -> v1)));

    public static OtoSellerStatusEnum getBySellerStatus(Integer sellerStatus) {
        if (Objects.isNull(sellerStatus)) {
            return null;
        }

        return ENUM_MAP.get(sellerStatus);
    }

}
