package cn.com.duiba.oto.enums.interview;

import com.google.common.collect.ImmutableMap;
import lombok.Getter;

import java.util.Objects;

/**
 * @author xuanhongjian
 */
@Getter
public enum ScanCodeTypeEnum {
    /**
     * 面访客户扫码类型，1:扫描二维码2:长按图片识别二维码3：扫描手机相册中的二维码
     */
    SCANNING(1047, "扫描小程序码"),
    PRESS(1048, "长按图片识别小程序码"),
    PHOTO_ALBUM(1049, "扫描手机相册中的小程序码");
    private static final ImmutableMap<Integer, ScanCodeTypeEnum> INNER_MAP;

    static {
        ImmutableMap.Builder<Integer, ScanCodeTypeEnum> builder = ImmutableMap.builder();
        for (ScanCodeTypeEnum item : ScanCodeTypeEnum.values()) {
            builder = builder.put(item.code, item);
        }
        INNER_MAP = builder.build();
    }

    private final Integer code;
    private final String desc;

    ScanCodeTypeEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static ScanCodeTypeEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }
}
