package cn.com.duiba.oto.oto.service.api.remoteservice.seller;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.seller.InterviewSceneConfDto;
import cn.com.duiba.oto.param.oto.seller.InterviewSceneConfSearchParam;
import cn.com.duiba.oto.param.oto.seller.InterviewSceneParam;

import java.util.List;

/**
 * @Author meichang
 * @Date 2022/5/18 13:50
 * @Version 1.0
 */
@AdvancedFeignClient
public interface RemoteOtoSceneConfService {

    /**
     * 新增、编辑面试场景配置
     * @param interviewSceneConfDto
     * @return 是否成功
     */
    Boolean saveOrUpdateInterviewSceneConf(InterviewSceneConfDto interviewSceneConfDto);

    /**
     * 根据id修改场景配置状态--启用/禁用
     */
    Boolean updateSceneConfStatusById(InterviewSceneConfDto interviewSceneConfDto);

    /**
     * 根据id删除场景配置
     * @param id
     * @return
     */
    Boolean deleteSceneConfStatusById(Long id);

    /**
     * 根据id查询场景配置
     */
    InterviewSceneConfDto getInterviewSceneConfById(Long id);

    /**
     * 根据id列表查询场景配置
     */
    List<InterviewSceneConfDto> getInterviewSceneConfByIdList(List<Long> ids);

    /**
     * 分页查询场景配置
     */
    List<InterviewSceneConfDto> listSceneConf(InterviewSceneConfSearchParam param);

    /**
     * 查询场景配置总数
     * @return
     */
    Long listSceneConfCount();

    /**
     * 根据公司id和客户阶段查询场景配置
     * @param param 参数
     * @return
     */
    List<InterviewSceneConfDto> listSceneConfByCompanyId(InterviewSceneParam param);

    /**
     * 根据公司id查询场景配置 不过滤未启用的场景
     * @param param 参数
     * @return
     */
    List<InterviewSceneConfDto> getSceneConfListByCompanyId(InterviewSceneParam param);

    /**
     * 校验场景配置状态
     *
     * @param interviewConfId
     * @throws BizException
     */
    void checkSceneConfStatus(Long interviewConfId) throws BizException;

    /**
     * 根据场景ID批量查询场景
     *
     * @param ids 场景ID集合
     */
    List<InterviewSceneConfDto> selectByIds(List<Long> ids);

}
