package cn.com.duiba.oto.enums.cust;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-06-29 13:52
 */
@AllArgsConstructor
@Getter
public enum CustActionTypeEnum {

    INVALID("00", "未知行为"),
    FORM("01", "填单客户"),
    LAUNCH_LIVE("02", "公域直播客户"),
    CONSULT("03", "咨询客户"),
    OLD("04", "缘故客户"),
    INTRODUCE("05", "转介绍客户"),
    LIVE_FISSION("06", "直播裂变"),
    INTELLIGENT_PHONE("07", "智能电话"),
    ASSIST("08", "助手客户"),
    COMMUNITY("09", "线下社区"),
    CORP_WX("10", "企微"),
    VIDEO("11", "视频号"),
    TAIBAO("12", "太保合作"),
    INVITE_INTRODUCE("13", "邀约转介绍客户"),
    COMMUNITY_INTRODUCE("14", "社区转介绍客户"),
    OA("15", "公众号"),
    ;

    /**
     * 客户类型
     */
    private final String type;

    /**
     * 客户描述
     */
    private final String desc;

    private static final Map<String, CustActionTypeEnum> INNER_MAP = Arrays.stream(values()).collect(Collectors.toMap(CustActionTypeEnum::getType, Function.identity(), (v1, v2) -> v1));

    public static CustActionTypeEnum getByCode(String type) {
        return Objects.isNull(type) ? null : INNER_MAP.get(type);
    }
}
