package cn.com.duiba.oto.oto.service.api.remoteservice.activity;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.activity.ActivityConfigDto;
import cn.com.duiba.oto.dto.oto.activity.ActivityRecordDto;

import java.util.List;

/**
 * 功能描述：活动相关
 *
 * @Auther: xiaotian
 * @Date: 2023/1/30 09:58
 * @Description:
 */
@AdvancedFeignClient
public interface RemoteActivityService {

    /**
     * 获取配置的活动列表
     *
     * @return
     */
    List<ActivityConfigDto> activityList();

    /**
     * 保存活动参与记录
     *
     * @param activityRecordDto
     * @return
     */
    int insert(ActivityRecordDto activityRecordDto);

    /**
     * 保存活动参与记录
     */
    int save(ActivityRecordDto activityRecordDto);

    /**
     * 根据用户id和活动id，获取参与记录
     *
     * @param userId
     * @param activityId
     * @return
     */
    List<ActivityRecordDto> selectByUserAndActivity(Long userId, Long activityId);


    /**
     * 根据用户id，删除活动参与记录
     *
     * @param userId
     * @return
     */
    int deleteByUserId(Long userId);
}
