package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.OtoCustFollowCountDto;
import cn.com.duiba.oto.dto.oto.cust.OtoCustomerExtDto;

import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-11 13:51
 */
@AdvancedFeignClient
public interface RemoteOtoCustExtService {

    /**
     * 根据客户id获取客户ext信息
     * @param custId 客户id
     * @return 客户ext信息
     */
    OtoCustomerExtDto findByCustId(Long custId);

    /**
     * 修改客户ext信息
     * @param dto 客户ext信息
     * @return 客户ext信息
     */
    boolean updateByCustId(OtoCustomerExtDto dto);

    /**
     * 修改客户核心决策人
     * @param dto 客户ext信息
     * @return 客户ext信息
     */
    boolean updateCoreMakerByCustId(OtoCustomerExtDto dto);

    /**
     * 根据客户流程组状态统计客户数
     * @param otoSid oto销售id
     * @return 客户统计数
     */
    List<OtoCustFollowCountDto> getCountByCustFlow(Long otoSid);

    /**
     * 根据客户ids获取客户ext信息
     * @param custIdList 客户id
     * @return 客户ext信息
     */
    List<OtoCustomerExtDto> getCustomerExtDtoList(List<Long> custIdList);

    /**
     * Excel批量插入客户
     * @param otoCustomerExtDtos
     * @return
     */
    List<OtoCustomerExtDto> batchInsertByExcel(List<OtoCustomerExtDto> otoCustomerExtDtos);

    /**
     * 批量修改客户ext信息
     * @param dto 客户ext信息
     * @return 客户ext信息
     */
    boolean batchUpdateByCustIds(OtoCustomerExtDto dto);

    /**
     * 批量修改客户ext信息
     * @param dtos 客户ext信息
     * @return 客户ext信息
     */
    boolean batchUpdateExtByCustIds(List<OtoCustomerExtDto> dtos);

    /**
     * 根据客户ids获取客户ext信息
     * @param custIdList 客户id
     * @return 客户ext信息
     */
    List<OtoCustomerExtDto> getCustomerExtDtoListByCustIds(List<Long> custIdList);

    /**
     * 清空专家
     * @param custIds
     * @return
     */
    int clearExpertSellerId(List<Long> custIds);

    /**
     * 根据是否成单查询客户
     * @param dealFlag
     * @return
     */
    List<OtoCustomerExtDto> getByDealFlag(Integer dealFlag);
}
