package cn.com.duiba.oto.vo;

import cn.com.duiba.oto.enums.DownloadStatusEnums;
import lombok.Data;

import java.io.Serializable;

@Data
public class ExportVo implements Serializable {
    private static final long serialVersionUID = -4621193460614980381L;

    /**
     * 问卷地址
     * 当downloadStatus=3时有值
     */
    private String ossUrl;

    /**
     * 导出状态
     */
    private Integer downloadStatus;


    public static ExportVo fail() {
        ExportVo exportVo = new ExportVo();
        exportVo.setDownloadStatus(DownloadStatusEnums.FAILURE.getStatus());
        return exportVo;
    }

    public static ExportVo success(String ossUrl) {
        ExportVo exportVo = new ExportVo();
        exportVo.setDownloadStatus(DownloadStatusEnums.SUCCESS.getStatus());
        exportVo.setOssUrl(ossUrl);
        return exportVo;
    }

    public static ExportVo processing() {
        ExportVo exportVo = new ExportVo();
        exportVo.setDownloadStatus(DownloadStatusEnums.PROCESSING.getStatus());
        return exportVo;
    }
}
