package cn.com.duiba.oto.dto.oto.cust;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2022/10/13 13:55
 * @Description:
 */
@Data
public class OtoCustDto implements Serializable {

    private static final long serialVersionUID = 7630247264568416244L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 客户所处资源池类型
     * @see cn.com.duiba.oto.enums.cust.OtoCustPoolEnum
     */
    private Integer poolType;

    /**
     * 当前跟进邀约人id
     */
    private Long inviteId;

    /**
     * 销售Id
     */
    private Long sellerId;

    /**
     * 专家Id
     */
    private Long expertId;

    /**
     * 客户名称
     */
    private String custName;

    /**
     * 见面次数
     */
    private Integer meetTimes;

    /**
     * 盘点次数
     */
    private Integer checkTimes;

    /**
     * 是否讲解计划书
     */
    private Integer commitPlanFlag;

    /**
     * 最近盘客户时间
     */
    private String lastCheckTime;

    /**
     * 承接时间
     */
    private String assignTime;

    /**
     * 是否重点跟进
     */
    private Integer custStar;

    /**
     * 最近一次见面时间
     */
    private String lastMeetTime;

    /**
     * 最早一次见面时间
     */
    private String fristMeetTime;

    /**
     * 联系次数
     */
    private Integer callTimes;

    /**
     * 最近联系时间
     */
    private String lastCallTime;

    /**
     * 重点跟进人
     */
    private Integer followUp;

    /**
     * 见面场景配置ID
     */
    private List<Long> sceneIds;

    /**
     * 促单情况 0取消促单 1标记促单
     */
    private Integer promotionType;

    /**
     * 是否放弃  0否 1是
     */
    private Integer hasGiveUp = 0;

    /**
     * 是否只有邀约 0否 1是
     */
    private Integer hasInviteNotHasSellerAndExpert;

    /**
     * 标签id
     */
    private List<Long> tagIds;

    /**
     * 参与直播的行为
     */
    private List<Integer> liveActions;

    /**
     * 参与直播id列表
     */
    private List<String> liveIds;

    /**
     * 是否上传kyc
     */
    private Integer isUploadKyc = 0;

    /**
     * 是否上传方案
     */
    private Integer isUploadPlan = 0;

    /**
     * kyc合格状态 0未上传 1合格 2不合格 3已上传无状态
     */
    private Integer kycStatus = 0;

    /**
     * 是否上传风险评估报告 0否 1是
     */
    private Integer isUploadEvaluate = 0;

    /**
     * 客户分类 1：未见面 2：已初次见面 3：已上传kyc 4：已上传风险评估报告 5：已上传方案 6：促单客户 7:已讲解方案客户
     */
    private Integer custType;

    /**
     * 阶段后的第一条call时间间隔
     */
    private Integer phaseCallTimeInterval;

    /**
     * 上传kyc时间
     * 当前专家第一次面访后的第一次上传时间
     */
    private String uploadKycTime;

    /**
     * 上传方案时间
     * 当前专家第一次面访后的第一次上传时间
     */
    private String uploadPlanTime;

    /**
     * 上传上传风险评估报告时间
     * 当前专家第一次面访后的第一次上传时间
     */
    private String uploadEvaluateTime;

    /**
     * 讲解方案时间
     * 当前专家第一次面访后的第一次讲解时间
     */
    private String planExplainTime;
}
