package cn.com.duiba.oto.enums.cust;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * OTO 流程组名称
 *
 * @author MeiChang
 * @Description
 */
@Getter
public enum CustColumuarAnalysisEnum {
    /**
     * 柱状图分析
     */
    FOLLOW_CUSTOMER(1, "入库客户"),
    NOT_MEET(2, "未见面"),
    HAS_MEET(3, "已初次见面"),
    KYC(4, "已上传kyc"),
    RISK_REPORT(5, "已出风险评估报告"),
    UPLOAD_PLAN(6, "已上传解决方案"),
    PROMOTION(7, "促单"),
    DEAL(8, "成单"),
    ;

    private static final Map<Integer, CustColumuarAnalysisEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(CustColumuarAnalysisEnum::getCode, Function.identity(), (v1, v2)->v1)));;


    private final Integer code;
    private final String desc;

    CustColumuarAnalysisEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CustColumuarAnalysisEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code){
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
