package cn.com.duiba.oto.oto.service.api.remoteservice.dept;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.dept.DeptAndSellerDto;
import cn.com.duiba.oto.dto.oto.dept.DeptDto;
import cn.com.duiba.oto.dto.oto.dept.DeptSellerDto;
import cn.com.duiba.oto.dto.oto.dept.OtoDepartmentDto;
import cn.com.duiba.oto.param.oto.dept.DeptAddParam;
import cn.com.duiba.oto.param.oto.dept.DeptBatchAddSellerParam;
import cn.com.duiba.oto.param.oto.dept.DeptDelParam;
import cn.com.duiba.oto.param.oto.dept.DeptSellerPageParam;
import cn.com.duiba.oto.param.oto.dept.DeptUpdateParam;

import java.util.List;
import java.util.Map;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-06-16 13:46
 */
@AdvancedFeignClient
public interface RemoteSellerDeptService {

    /**
     * 查看部门列表
     *
     * @return 部门列表
     */
    List<DeptDto> list();

    /**
     * 新增部门
     *
     * @return 是否成功
     */
    Boolean save(DeptAddParam deptAddParam) throws BizException;

    /**
     * 修改部门
     *
     * @return 是否成功
     */
    Boolean update(DeptUpdateParam deptUpdateParam) throws BizException;

    /**
     * 删除部门
     *
     * @return 是否成功
     */
    Boolean delete(DeptDelParam deptDelParam) throws BizException;

    /**
     * 批量设置部门成员
     *
     * @return 是否成功
     */
    Boolean batchAddSeller(DeptBatchAddSellerParam deptBatchAddSellerParam) throws BizException;

    /**
     * 查看部门下的成员列表
     *
     * @return 成员列表
     */
    DeptSellerDto listSellerByDeptId(DeptSellerPageParam deptSellerPageParam) throws BizException;

    /**
     * 根据销售id获取可以访问的数据sellerId的列表（数据权限使用）
     *
     * @param sellerId
     * @return
     */
    List<Long> authSellerIds(Long sellerId);

    /**
     * 根据销售id，获取该销售所绑定的部门id列表
     *
     * @param sellerId
     * @return
     */
    List<Long> deptList(Long sellerId);

    /**
     * 是否开启组织架构数据权限
     *
     * @return
     */
    boolean openDeptAuth();


    /**
     * 根据销售ID获取该销售绑定的所有最小级部门
     *
     * @param sid 销售ID
     * @return 所有最小级部门ID
     */
    List<Long> getMinimumDeptIdsBySid(Long sid);

    /**
     * 根据销售ID获取该销售绑定的所有最小级部门
     *
     * @param sids 销售ID
     * @return 所有最小级部门ID
     */
    Map<Long, List<Long>> getMinimumDeptIdsBySids(List<Long> sids);

    /**
     * 根据部门ID查询部门信息
     *
     * @param ids 部门ID
     * @return 部门信息
     */
    List<OtoDepartmentDto> getDeptListByIds(List<Long> ids);

    /**
     * 根据部门ID查询部门信息(不传ids查询所有)
     *
     * @param ids 部门ID
     * @return 部门信息
     */
    List<OtoDepartmentDto> obtainDeptListByIds(List<Long> ids);

    /**
     * 根据部门ID查询该部门及子部门的所有成员
     *
     * @param deptIds 部门ID集合
     * @return 成员id
     */
    List<Long> getSidsByDeptIds(List<Long> deptIds);

    /**
     * 根据部门ID查询该部门及子部门的所有成员
     *
     * @param deptId 部门ID
     * @return 成员id和部门ID
     */
    List<DeptAndSellerDto> getSidsByDeptId(Long deptId);


    /**
     * 根据部门ID获取下属所有最小级部门
     *
     * @param deptId 部门id
     * @return 所有最小级部门ID
     */
    List<Long> getMinimumDeptIdsByDeptId(Long deptId);

}
