package cn.com.duiba.oto.dto.oto.cust;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 客户参观记录表
 * @author kjj mybatis generator 
 * @date 2022-01-10
 */
@Data
public class CustVisitRecordDto implements Serializable {
     
    private static final long serialVersionUID = 1641794523446518L;

    /**
     * 主键id
     */
    private Long id;

    /**
     * 销售id
     */
    private Long sellerId;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 参观状态 1已预约 2已上传参观反馈
     * @see cn.com.duiba.oto.enums.cust.visit.OtoCustVisitStatusEnum
     */
    private Integer visitStatus;

    /**
     * 预约参观日期
     */
    private Date orderVisitTime;

    /**
     * 成交决策人 1自己 2配偶 3父母 4子女
     * @see cn.com.duiba.oto.enums.cust.visit.OtoCustFamilyTypeEnum
     */
    private Integer coreMaker;

    /**
     * 理念是否认同 0不认同 1认同
     * @see cn.com.duiba.kjy.base.api.enums.BooleanEnum
     */
    private Integer ideaAgree;

    /**
     * 投保人 1自己 2配偶 3父母 4子女
     * @see cn.com.duiba.oto.enums.cust.visit.OtoCustFamilyTypeEnum
     */
    private Integer insApplicant;

    /**
     * 被投保人 1自己 2配偶 3父母 4子女
     * @see cn.com.duiba.oto.enums.cust.visit.OtoCustFamilyTypeEnum
     */
    private Integer insByApplicant;

    /**
     * 投保金额
     */
    private Integer insMoney;

    /**
     * 投保期数
     */
    private Integer insPeriod;

    /**
     * 提交方案后客户状态 1近期有机会成交 2近期无法成交 3拒绝
     * @see OtoCustCommitStatusEnum
     */
    private Integer commitCustStatus;

    /**
     * 是否提交养老规划方案 0否 1是
     * @see cn.com.duiba.kjy.base.api.enums.BooleanEnum
     */
    private Integer commitPlanFlag;

    /**
     * 参观备注
     */
    private String visitRemark;

    /**
     * 跟进客户权重
     * @see cn.com.duiba.oto.enums.cust.follow.OtoCustFollowWeightEnum
     */
    private Integer followWeight;

    /**
     * 客户价值  1XX代表未接通 2XX中XX代表分数 3XX代表系统高价值
     * @see cn.com.duiba.oto.enums.cust.ext.OtoCustValueEnum
     */
    private Integer custValue;

    /**
     * 销售评价类型
     * @see cn.com.duiba.oto.enums.OtoCommentTypeEnum
     */
    private Integer commentType;

    /**
     * 创建时间
     */
    private Date gmtCreate;
}