package cn.com.duiba.oto.enums.cust;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-06-29 13:52
 */
@AllArgsConstructor
@Getter
public enum CustPlanStatusEnum {

    PLANING(1, "计划中"),
    PLAN_FINISH(2, "已完成"),
    PLAN_NOT_FINISH(3, "未完成"),
    ;

    /**
     * 类型
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String desc;

    private static final Map<Integer, CustPlanStatusEnum> INNER_MAP = Arrays.stream(values()).collect(Collectors.toMap(CustPlanStatusEnum::getCode, Function.identity(), (v1, v2) -> v1));

    public static CustPlanStatusEnum getByCode(Integer type) {
        return Objects.isNull(type) ? null : INNER_MAP.get(type);
    }
}
