package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.OtoCustPlanDto;
import cn.com.duiba.oto.param.oto.cust.OtoCustPlanSaveParam;
import cn.com.duiba.oto.param.oto.cust.OtoCustPlanSearchParam;

import java.util.List;


@AdvancedFeignClient
public interface RemoteOtoCustPlanService {

    /**
     * 根据条件查询客户计划 分页
     * @param param 查询条件
     * @return 结果
     */
    List<OtoCustPlanDto> getCustPlanListByParam(OtoCustPlanSearchParam param);

    /**
     * 根据条件查询客户计划
     * @param param 查询条件
     * @return 结果
     */
    Long getCustPlanCountByParam(OtoCustPlanSearchParam param);

    /**
     * 批量保存
     * @param params 参数
     * @return 保存成功数量
     */
    int batchSaveCustPlan(List<OtoCustPlanSaveParam> params);

    /**
     * 根据条件查询客户计划 不分页
     * @param param 查询条件
     * @return 结果
     */
    List<OtoCustPlanDto> selectCustPlanListByParam(OtoCustPlanSearchParam param);
}
