package cn.com.duiba.oto.enums;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-02-28 14:52
 */
@Getter
@AllArgsConstructor
public enum CustValueWeightSceneEnum {

    DIRECT_CUST_VALUE(1, "直接修改客户价值"),
    DIRECT_FOLLOW_WEIGHT(2, "直接修改客户等级"),
    MEET_CUST_FEEDBACK(3, "客户面访反馈"),
    VISIT_CUST_FEEDBACK(4, "客户参观反馈"),
    CALL_CUST_FEEDBACK(5, "客户电话反馈"),
    CALL_BACK_FEEDBACK(6, "第三方通话信息回调")
    ;

    /**
     * 场景
     */
    private final Integer scene;

    /**
     * 描述
     */
    private final String desc;

}
