package cn.com.duiba.oto.enums;

import com.google.common.collect.Lists;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Collections;
import java.util.List;

/**
 * 描述：kjy_live_normal 库的 tb_cust_interview_record 表的 interview_status 字段的枚举类
 *
 * @author zhouziwu
 * @date 2022-03-24
 */
@AllArgsConstructor
@Getter
public enum OtoCustInterviewStatusEnum {
    /** 待授权 */
    WAIT_AUTHORIZATION(1, 1,"待授权"),

    /** 待确认 */
    @Deprecated
    WAIT_CONFIRM(2, -1,"待确认"),

    /** 待上传面访详情 */
    WAIT_UPLOAD_INTERVIEW_DETAIL(3, 3,"待上传面访详情"),

    /** 面访完成 */
    INTERVIEW_FINISH(4, 5,"面访完成"),

    /** 授权失败 */
    INTERVIEW_FAIL(5, 2,"授权失败"),

    /** 审批中 */
    INTERVIEW_AUDIT(6, 4,"审批中"),

    /** 已失效 */
    INTERVIEW_LOSE(7, 6,"已失效"),
    ;

    /**
     * 表明客户已到场的，几种邀约状态
     */
    public static final List<Integer> CUST_MEET_STATUS = Collections.unmodifiableList(Lists.newArrayList(INTERVIEW_FINISH.getStatus(), INTERVIEW_AUDIT.getStatus(), INTERVIEW_LOSE.getStatus()));

    private Integer status;
    private Integer order;
    private String desc;
}
