package cn.com.duiba.oto.enums.cust;

import lombok.AllArgsConstructor;
import lombok.Getter;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-01-05 17:54
 * 客户信息排序枚举
 */
@Getter
@AllArgsConstructor
public enum OtoCustExtraSortTypeEnum {

    LAST_ASSIGN_TIME(1, "分配时间正序"),
    LAST_ASSIGN_TIME_DESC(2, "分配时间逆序"),
    LAST_FOLLOW_TIME(3, "跟进时间正序"),
    LAST_FOLLOW_TIME_DESC(4, "跟进时间逆序"),
    ;

    /**
     * 排序字段
     */
    private final Integer type;

    /**
     * 描述
     */
    private final String desc;
}
