package cn.com.duiba.oto.oto.service.api.remoteservice.fix;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

import java.util.List;

/**
 * @author xiongkai
 * @version 1.0
 * @date 2022-02-14 15:27
 * 自动化测试api
 */
@AdvancedFeignClient
public interface RemoteAutoTestApiService {

    /**
     * 清除客户信息
     * @param custId 客户id
     * @return 操作结果
     */
    boolean clearCust(Long custId);

    /**
     * 批量重置客户所处流程组
     * 该操作的影响面如下：
     * 1.面访记录表：删除该客户与当前跟进人的所有面访记录
     * 2.客户扩展表：是否用户提交养老规划方案=false、 是否确认投保要素=false、是否成单=false
     *
     * @param custIds 客户id集合
     * @return 重置结果
     */
    boolean batchResetCustFlow(List<Long> custIds);

    /**
     * 批量初始化客户所处流程组
     * 会按照流程组要求新增面访记录与修改客户扩展信息
     *
     * @param custIds  客户id
     * @param flow 客户需要初始化的目标流程组
     * @return 初始化结果
     */
    boolean batchInitCustFlow(List<Long> custIds, Integer flow);

    /**
     * oto删除tb_pub_form_record表数据（自动化测试专用）
     * @param phoneNum 手机号
     * @return 删除结果
     */
    boolean delPubFormRecord(String phoneNum);
}
