package cn.com.duiba.oto.oto.service.api.remoteservice.serviceCard;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.serviceCard.ServiceCardDto;
import cn.com.duiba.oto.dto.oto.serviceCard.ServiceCardOrderConfigDto;
import cn.com.duiba.oto.param.oto.pay.response.wxpay.WxPayLiteChargeResponse;
import cn.com.duiba.oto.param.oto.serviceCard.ActivateParam;
import cn.com.duiba.oto.param.oto.serviceCard.OrderParam;
import cn.com.duiba.oto.param.oto.serviceCard.SearchServiceCardParam;
import cn.com.duiba.oto.param.oto.serviceCard.SendMsgParam;
import cn.com.duiba.oto.util.PageResult;

import java.util.List;

/**
 * 客户养老服务卡
 * @author xiaotian
 * @date 2023/9/06 14:07
 */
@AdvancedFeignClient
public interface RemoteServiceCardService {

    /**
     * 服务卡列表
     */
    PageResult<ServiceCardDto> list(SearchServiceCardParam pageQuery);

    /**
     * 新增/修改服务卡
     */
    Long saveOrUpdate(ServiceCardDto serviceCardDto) throws BizException;

    /**
     * 删除服务卡
     */
    @Deprecated
    Boolean del(Long custId) throws BizException;

    /**
     * 删除服务卡(根据卡类型)
     */
    Boolean del(Long custId,Integer cardType) throws BizException;

    /**
     * 根据客户id，获取卡片信息
     * @param custId
     * @return
     */
    @Deprecated
    ServiceCardDto getCard(Long custId);

    /**
     * 根据客户id，获取卡片信息
     * @param custId
     * @return
     */
    List<ServiceCardDto> getCardList(Long custId);

    /**
     * 发送验证码
     */
    Boolean sendMsg(SendMsgParam param) throws BizException;

    /**
     * 激活服务卡
     */
    Boolean activate(ActivateParam param) throws BizException;

    /**
     * 获取在线订单的配置信息
     *
     * @return
     */
    @Deprecated
    ServiceCardOrderConfigDto getWxCardConfig();

    /**
     * 获取在线订单的配置信息(V2),包含不同类型的卡片
     * @return
     */
    List<ServiceCardOrderConfigDto> getWxCardConfigV2();

    /**
     * 下单服务卡
     */
    WxPayLiteChargeResponse order(OrderParam param) throws BizException;
}
