package cn.com.duiba.oto.param.oto.serviceCard;

import cn.com.duiba.oto.enums.serviceCard.CardTypeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * 功能描述：微信下单参数
 *
 * @Auther: xiaotian
 * @Date: 2023/3/25 09:57
 * @Description:
 */
@Data
public class OrderParam implements Serializable {
    private static final long serialVersionUID = 9088055753778989718L;

    /**
     * 手机号
     */
    private String phone;

    /**
     * 验证码
     */
    private String verificationCode;

    /**
     * 客户姓名
     */
    private String custName;
    /**
     * 客户id
     */
    private Long custId;

    /**
     * 当前登陆的微信体系userId
     */
    private Long userId;

    /**
     * 客户ip
     */
    private String clientIp;

    /**
     * 扫码购买的客户id（给这个客户id购买服务卡）
     */
    private Long payForcustId;

    /**
     * 卡片类型 1:永久卡 2:年卡
     * @see cn.com.duiba.oto.enums.serviceCard.CardTypeEnum
     */
    private Integer cardType = CardTypeEnum.FOREVER.getType();

}
