package cn.com.duiba.oto.enums.cust.call;

import lombok.AllArgsConstructor;
import lombok.Getter;
import org.apache.commons.lang.StringUtils;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-06 20:07
 */
@AllArgsConstructor
@Getter
public enum OtoCustomerCallStatusEnum {

    DEALING(1, "dealing", "已接听"),
    NOT_DEAL(2, "notDeal", "振铃未接听"),
    VOICE_MAIL(3, "voicemail", "已留言"),
    BLACK_LIST(4, "blackList", "黑名单"),
    QUEUE_LEAK(5, "queueLeak", "排队放弃"),
    LEAK(6, "leak", "ivr"),
    ROBOT_SERVER(7, "robotServer", "机器人");


    /**
     * 状态
     */
    private final Integer status;

    /**
     * 字段
     */
    private final String filed;

    /**
     * 备注
     */
    private final String desc;

    /**
     * 字段状态Map
     */
    public static final Map<String, Integer> FIELD_STATUS_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustomerCallStatusEnum::getFiled, OtoCustomerCallStatusEnum::getStatus)));

    /**
     * 根据字段获取状态
     */
    public static Integer getStatusByField(String field){
        if (StringUtils.isBlank(field)) {
            return null;
        }
        return FIELD_STATUS_MAP.get(field);
    }

}
