/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.oto.enums.pay;

import cn.com.duiba.oto.enums.pay.PayTypeEnum;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public enum ChannelTypeEnum {
    WX_LITE("wx_lite", "\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u652f\u4ed8", PayTypeEnum.WX_PAY.getType());

    private static final Map<String, ChannelTypeEnum> ENUM_MAP;
    private final String channelType;
    private final String channelName;
    private final Integer payType;

    public static ChannelTypeEnum getByChannelType(String channelType) {
        if (channelType == null) {
            return null;
        }
        return ENUM_MAP.get(channelType);
    }

    public static boolean isActive(String channelType) {
        if (StringUtils.isBlank((String)channelType)) {
            return false;
        }
        return ChannelTypeEnum.getByChannelType(channelType) != null;
    }

    public String getChannelType() {
        return this.channelType;
    }

    public String getChannelName() {
        return this.channelName;
    }

    public Integer getPayType() {
        return this.payType;
    }

    private ChannelTypeEnum(String channelType, String channelName, Integer payType) {
        this.channelType = channelType;
        this.channelName = channelName;
        this.payType = payType;
    }

    static {
        ENUM_MAP = new HashMap<String, ChannelTypeEnum>();
        for (ChannelTypeEnum typeEnum : ChannelTypeEnum.values()) {
            ENUM_MAP.put(typeEnum.getChannelType(), typeEnum);
        }
    }
}

