package cn.com.duiba.oto.enums.form.customer;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 公域引流-客户管理是否带看枚举
 *
 * @author xiaocong
 * @date 2021/11/17 8:00 下午
 */
@AllArgsConstructor
@Getter
public enum PubFormCustomerLeadEnum {

    /**
     * 否
     */
    UN_LEAD(0, "否"),

    /**
     * 是
     */
    LEAD(1, "是");

    /**
     * code
     */
    private final Integer code;

    /**
     * 描述
     */
    private final String description;


    public static final Map<Integer, String> LEAD_MAP;

    static {
        Map<Integer, String> map = Arrays.stream(values()).collect(Collectors.toMap(PubFormCustomerLeadEnum::getCode, PubFormCustomerLeadEnum::getDescription));
        LEAD_MAP = Collections.unmodifiableMap(map);
    }
}
