package cn.com.duiba.oto.dto.oto.audit;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 审核通用表
 * @author kjj mybatis generator 
 * @date 2022-06-01
 */
@Data
public class OtoAuditDto implements Serializable {
     
    private static final long serialVersionUID = 16540625622786854L;

    /**
     * 主键
     */
    private Long id;

    /**
     * 业务ID/业务内容
     */
    private String bizId;

    /**
     * 审批类型 1入职审批 2离职审批
     */
    private Byte bizType;

    /**
     * 审批状态 1待审批 2 已通过 3已驳回
     */
    private Byte auditType;

    /**
     * 审批备注
     */
    private String auditRemark;

    /**
     * 审批时间
     */
    private Date auditTime;

    /**
     * 审核人
     */
    private Long auditId;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 修改时间
     */
    private Date gmtModified;
}