package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.CustCallRecordDto;

import java.util.Date;
import java.util.List;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-16 10:00
 */
@AdvancedFeignClient
public interface RemoteCustCallRecordService {

    /**
     * 根据日志id获取通话记录
     * @param callLogId 日志id
     * @return 通话记录
     */
    CustCallRecordDto findByCallLogId(Long callLogId);

    /**
     * 保存通话记录
     *
     * @param custCallRecordDto 通话记录
     * @return 保存结果
     */
    boolean save(CustCallRecordDto custCallRecordDto);

    /**
     * 更新通话记录
     *
     * @param custCallRecordDto 通话记录
     * @return 保存结果
     */
    boolean update(CustCallRecordDto custCallRecordDto);

    /**
     * 保存预生成通话跟进记录
     *
     * @param custCallRecordDto 预生成跟进记录
     * @return 保存结果
     */
    Long savePreGenerated(CustCallRecordDto custCallRecordDto);

    /**
     * 更新预生成通话跟进记录
     * @param custCallRecordDto 更新记录预生成跟进记录
     * @return 更新结果
     */
    boolean updatePreGenerated(CustCallRecordDto custCallRecordDto);


    /**
     * 根据ID查询通话跟进记录
     * @param id ID
     * @return CustCallRecordDto
     */
    CustCallRecordDto findById(Long id);

    /**
     * 查询收到未回调的通话记录
     * @param sellerId 客户ID
     * @param custId 销售ID
     * @return 通话跟进记录
     */
    List<CustCallRecordDto> getNotCallBackRecords(Long sellerId,Long custId);

    /**
     * 更新结束方式和结束时间
     * @param endType 结束方式
     * @param endTime 结束时间
     * @param callLogId 通话日志 ID
     * @param id 主键
     * @return 操作结果
     */
    boolean updateCallEndTypeAndTime(Integer endType,Date endTime,Long callLogId,Long id);

    /**
     * 获取最近一条未提交的跟进记录
     * @param sellerId 销售id
     * @param custId 客户ID
     * @return 最近一条未提交的跟进记录
     */
    CustCallRecordDto getLastRecord(Long sellerId,Long custId);

    /**
     * 获取客户的表单通话记录
     * @return
     */
    List<CustCallRecordDto> getListByCustId(Long custId);
}
