package cn.com.duiba.oto.oto.service.api.remoteservice.cust;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.cust.OtoCustKycSchemeDto;
import cn.com.duiba.oto.param.oto.cust.OtoCustKycSchemeSaveParam;

import java.util.List;


@AdvancedFeignClient
public interface RemoteOtoCustKycSchemeService {

    /**
     * 新增
     * @param param 参数
     * @return 结果
     */
    Boolean save(OtoCustKycSchemeSaveParam param);

    /**
     * 新增
     * @param param 参数
     * @return 结果
     */
    Boolean update(OtoCustKycSchemeSaveParam param);

    /**
     * 根据客户ID查询
     * @param custId 客户ID
     * @return 结果
     */
    List<OtoCustKycSchemeDto> findByCustId(Long custId);

    /**
     * 根据客户ID查询
     * @param id 主键id
     * @return 结果
     */
    OtoCustKycSchemeDto findById(Long id);

    /**
     * 根据客户ID和上传类型 分页查询
     * @param custId 客户ID
     * @param uploadType 类型
     * @param offset 起始页
     * @param limit 每页数据条数
     * @return 结果
     */
    List<OtoCustKycSchemeDto> findByCustIdAndType(Long custId, Integer uploadType, Integer offset, Integer limit);

    /**
     * 根据客户ID和上传类型 分页查询V2
     * @param custId 客户ID
     * @param uploadTypes 类型
     * @param offset 起始页
     * @param limit 每页数据条数
     * @return 结果
     */
    List<OtoCustKycSchemeDto> findByCustIdAndTypes(Long custId, List<Integer> uploadTypes, Integer offset, Integer limit);

    /**
     * 根据客户ID和上传类型 分页查询
     * @param custId 客户ID
     * @param uploadType 类型
     * @return 数量
     */
    Long findCountByCustIdAndType(Long custId, Integer uploadType);

    /**
     * 根据客户ID和上传类型 查询数量V2
     * @param custId 客户ID
     * @param uploadTypes 类型
     * @return 数量
     */
    Long findCountByCustIdAndTypes(Long custId, List<Integer> uploadTypes);

    /**
     * 根据客户ID集合和上传类型过滤
     * @param custIds 客户ID集合
     * @param uploadType 上传类型
     */
    List<OtoCustKycSchemeDto>  findByCustIdsAndUploadType(List<Long> custIds, Integer uploadType);
}
