package cn.com.duiba.oto.enums.excelImport;

import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

/**
 * 功能描述：导入任务类型枚举
 *
 * @Auther: xiaotian
 * @Date: 2023/5/18 16:23
 * @Description:
 */
@Getter
@AllArgsConstructor
public enum OtoImportTaskTypeEnum {

        OTO_BATCH_IMPORT_CUSTOMER_TASK(127, "批量导入客户任务"),

        OTO_BATCH_IMPORT_CHECK_TASK(126, "批量导入盘点任务"),

        OTO_BATCH_IMPORT_ERROR_INTWEVIEW_TASK(125, "批量导入异常面访修复数据任务"),

        OTO_BATCH_IMPORT_ASSIGN_CUST_TASK(125, "批量分配客户数据任务"),
        ;

        /**
         * 导入任务类型
         */
        private final Integer taskType;

        /**
         * 描述
         */
        private final String desc;

        private static final Map<Integer, OtoImportTaskTypeEnum> MAP = new HashMap<>();

        static {
            Arrays.stream(values()).forEach(type -> MAP.put(type.getTaskType(), type));
        }

        /**
         * 根据type获取枚举
         */
        public static OtoImportTaskTypeEnum getEnumByType(Integer type) {
            return MAP.get(type);
        }
}
