package cn.com.duiba.oto.param.oto.pay.request.alipay;

import cn.com.duiba.oto.param.oto.pay.request.BaseChargeRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

/**
 * 支付宝收单请求
 *
 * @author 吴文哲
 * @date 2020-07-09 10:04
 **/
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class AliPayWapChargeRequest extends BaseChargeRequest {

    /**
     * 对一笔交易的具体描述信息。如果是多种商品，请将商品描述字符串累加传给body
     */
    @NotNull(message = "支付描述不能为空")
    @Size(max = 128, message = "支付描述长度超过128")
    private String body;

    /**
     * 商品的标题/交易标题/订单标题/订单关键字等
     */
    @NotNull(message = "商品标题不能为空")
    @Size(max = 256, message = "商品标题长度超过256")
    private String subject;

}
