package cn.com.duiba.oto.param.oto.pay.response.alipay;

import cn.com.duiba.oto.annotation.FieldMapKey;
import cn.com.duiba.oto.enums.pay.ResponseCodeEnum;
import cn.com.duiba.oto.param.oto.pay.response.BaseChargeResponse;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

/**
 * 支付宝支付收单回执
 *
 * @author 吴文哲
 * @date 2020-07-09 10:01
 **/
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@Data
public class AliPayLiteChargeResponse extends BaseChargeResponse {

    private static final long serialVersionUID = 1670097931924886898L;

    /**
     * 返回给前端 那去支付宝付钱的Get请求
     */
    private String qrCode;

    /**
     * 网关返回码
     * 文档: https://doc.open.alipay.com/docs/doc.htm?treeId=291&articleId=105806&docType=1
     */
    @FieldMapKey("code")
    private String code;

    /**
     * 网关返回码描述
     * 文档: https://opendocs.alipay.com/open/common/105806
     */
    @FieldMapKey("msg")
    private String msg;

    /**
     * 业务返回码，参见具体的API接口文档
     */
    @FieldMapKey("sub_code")
    private String subCode;

    /**
     * 业务返回码描述，参见具体的API接口文档
     */
    @FieldMapKey("sub_msg")
    private String subMsg;

    @Override
    public boolean isSuccess() {
        return ResponseCodeEnum.ALI_SUCCESS_CODE.getCode().equals(code);
    }


}
