package cn.com.duiba.oto.enums.cust;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 客户经营看板业务枚举
 *
 * @author MeiChang
 * @Description
 */
@Getter
public enum CustBulletinBoardStatisticsSubForWorkLoadEnum {
    INTERVIEW(1, "面访总次数"),
    CALL_COUNT(2, "拨出次数"),
    CALL_TIME(3, "总通时"),
    WX_MSG(4, "微信消息数"),
    FRIEND(5, "加微好友数"),
    PLAN(6, "工作计划数量")
    ;

    private static final Map<Integer, CustBulletinBoardStatisticsSubForWorkLoadEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(CustBulletinBoardStatisticsSubForWorkLoadEnum::getCode, Function.identity(), (v1, v2)->v1)));;


    private final Integer code;
    private final String desc;

    CustBulletinBoardStatisticsSubForWorkLoadEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CustBulletinBoardStatisticsSubForWorkLoadEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code){
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
