package cn.com.duiba.oto.enums.cust;

import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * OTO 流程组名称
 *
 * @author MeiChang
 * @Description
 */
@Getter
public enum CustQualityEnum {
    /**
     * 客户经营看板2.0
     */
    TOTAL_CUSTOMER(1, "入库客户总数"),
    ACTIVATE_CUSTOMER(2, "激活客户总数"),
    ACTIVATE_CUSTOMER_HAS_FOLLOW(3, "激活客户总数-有人跟"),
    ACTIVATE_CUSTOMER_NOT_FOLLOW(4, "激活客户总数-无人跟"),
    PUB_OFFICE_WEBSITE_IMPORT(5, "投流客户数"),
    PUB_TENCENT_CLUE(6, "投流客户数-广点通"),
    PUB_FEIYU_CLUE(7, "投流客户数-巨量"),
    OTHER_OFFLINE_COMMUNITY(8, "小区客户数"),
    OTHER_INVITE_INTRODUCE(9, "转介绍客户数"),
    OTHER_OFFLINE_INVITE_INTRODUCE(10, "转介绍客户数-投流"),
    OTHER_OFFLINE_COMMUNITY_INTRODUCE(11, "转介绍客户数-社区"),
    OTHER_OFFLINE_VIDEO(12, "视频号客户数"),
    OTHER_ONLINE_MARKET(13, "公众号客户数"),
    PUB_OFFICE_WEBSITE_IMPORT_FROM(14, "官网客户数"),
    ;

    private static final Map<Integer, CustQualityEnum> INNER_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(CustQualityEnum::getCode, Function.identity(), (v1, v2)->v1)));;


    private final Integer code;
    private final String desc;

    CustQualityEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static CustQualityEnum getByCode(Integer code) {
        return Objects.isNull(code) ? null : INNER_MAP.get(code);
    }

    public static String getDescByCode(Integer code){
        if (code == null) {
            return null;
        }
        return INNER_MAP.get(code).getDesc();
    }
}
