package cn.com.duiba.oto.enums.separate;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiaotian
 * @date 2020/5/18 4:21 PM
 */
public enum ShowFlagEnum {
    //展示状态: 1:展示 0:不展示 2:超时 -1:删除
    SHOW(1, "展示"),
    NOT_SHOW(0, "不展示"),
    OUT_TIME(2, "超时"),
    DEL(-1, "删除"),
    ;

    /**
     * 包含所有枚举的Map
     */
    private static final Map<Integer, String> ALL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(ShowFlagEnum::getCode, ShowFlagEnum::getDesc, (v1, v2) -> v1)));
    private Integer code;
    private String desc;

    ShowFlagEnum(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    /**
     * 根据类型获取描述
     */
    public static String getDescCode(Integer code) {
        if (code == null) {
            return null;
        }
        return ALL_MAP.get(code);
    }

    public Integer getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }
}
