package cn.com.duiba.oto.oto.service.api.remoteservice.separate;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.separate.CustSeparateDto;
import cn.com.duiba.oto.dto.oto.separate.CustSeparateOrderDto;
import cn.com.duiba.oto.dto.oto.separate.NotifyDto;
import cn.com.duiba.oto.param.oto.separate.RemoteApplyParam;
import cn.com.duiba.oto.param.oto.separate.RemoteApproveParam;
import cn.com.duiba.oto.param.oto.separate.RemoteApproveSearchParam;
import cn.com.duiba.oto.param.oto.separate.RemoteCustTimeOutSearchParam;
import cn.com.duiba.oto.util.PageResult;

import java.util.List;

@AdvancedFeignClient
public interface RemoteOtoCustSeparateService {

    /**
     * 销售专家查看超时提醒客户数量
     */
    NotifyDto notifySeller(Long sellerId);

    /**
     * 留续申请管理
     *
     * @param param 查询条件
     */
    PageResult<CustSeparateDto> orderList(RemoteCustTimeOutSearchParam param);

    /**
     * 审批管理
     *
     * @param param 查询条件
     */
    PageResult<CustSeparateOrderDto> approveList(RemoteApproveSearchParam param);

    /**
     * 申请
     *
     * @param param 申请参数
     */
    Boolean apply(RemoteApplyParam param);

    /**
     * 审批
     *
     * @param param 审批参数
     */
    Boolean approve(RemoteApproveParam param);

    /**
     * 通过审批记录id，获取详情
     *
     * @return
     */
    List<CustSeparateOrderDto> listByIds(List<Long> ids);
}
