package cn.com.duiba.oto.oto.service.api.remoteservice.seller.submit;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.oto.dto.oto.seller.submit.OtoSellerFaceReportDto;
import cn.com.duiba.oto.dto.oto.seller.submit.OtoSellerSubmitRecordDto;
import cn.com.duiba.oto.param.oto.seller.submit.CheckSignParam;
import cn.com.duiba.oto.param.oto.seller.submit.SellerSubmitOtherParam;
import cn.com.duiba.oto.param.oto.seller.submit.SellerSubmitPageQuery;
import cn.com.duiba.oto.util.PageResult;

import java.util.Date;
import java.util.List;

/**
 * OTO-销售提报
 *
 * @author xiaotian
 * @date 2023/3/27 5:59 下午
 */
@AdvancedFeignClient
public interface RemoteOtoSellerSubmitService {

    /**
     * 新增销售提报记录
     *
     * @param otoSellerSubmitRecordDto
     * @return
     */
    boolean saveSubmitRecord(OtoSellerSubmitRecordDto otoSellerSubmitRecordDto);

    /**
     * 分页获取销售提报记录
     *
     * @return
     */
    PageResult<OtoSellerSubmitRecordDto> pageSubmitRecord(SellerSubmitPageQuery sellerSubmitPageQuery);

    /**
     * 获取销售的面访提报记录
     *
     * @return
     */
    List<OtoSellerFaceReportDto> faceReport(List<Long> sellerIds, Date curDate);


    /**
     * 获取销售的面访提报记录
     *
     * @return
     */
    List<OtoSellerFaceReportDto> faceReportForDates(Long sellerId, List<Date> curDates);

    /**
     * 获取销售的提报记录
     *
     * @return
     */
    List<OtoSellerSubmitRecordDto> submitRecords(List<Long> sellerIds, Date curDate);

    /**
     * 批量新增提报记录（seller-cust-configId-date）
     *
     * @param otoSellerFaceReportDtos
     * @return
     */
    boolean batchSaveFaceReport(List<OtoSellerFaceReportDto> otoSellerFaceReportDtos);


    /**
     * 提报
     *
     * @return 提报详情（其他见面场景）
     */
    Boolean submit(SellerSubmitOtherParam param);


    /**
     * 销售确认客户是否签到
     *
     * @return 是否成功
     */
    Boolean checkSign(CheckSignParam checkSignParam);

    /**
     * 获取配置的需要签到的见面场景
     *
     * @return
     */
    List<Long> signSenceIds();

    /**
     * 需要内勤crm手动签到的见面场景
     *
     * @return
     */
    List<Long> signSenceIdsV2();
}
