package cn.com.duiba.oto.param.oto.seller.submit;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * 功能描述：提交活动量参数
 *
 * @Auther: xiaotian
 * @Date: 2023/3/25 11:52
 * @Description:
 */
@Data
public class SellerSubmitOtherParam implements Serializable {
    private static final long serialVersionUID = -4389844914006645117L;

    /**
     * 销售id
     */
    private Long sellerId;

    /**
     * 时间
     */
    private String curDate;

    /**
     * 删除的活动提报ID集合
     */
    private List<Long> deleteFaceIds;

    /**
     * 非行事历上的其他见面场景
     */
    private List<OtherConfigParam> params;


    @Data
    public static class OtherConfigParam implements Serializable {

        private static final long serialVersionUID = -8217039703512458366L;

        /**
         * 活动提报ID
         */
        private Long faceId;

        /**
         * 客户id
         */
        private Long custId;

        /**
         * 见面场景id
         */
        private Long configId;

        /**
         * 见面目的 0-关系维护 1-参观社区 2-送计划书 3-踢单 4-参加财商/沙龙
         */
        private Integer custPhase;

        /**
         * 早上还是下午
         * am/pm
         */
        private String timeInterval;

        /**
         * 审批状态：
         * 若faceId为空，则该参数默认会置为0待审批
         * 若faceId不为空，则该参数不能为空
         */
        private Integer reportStatus;
    }
}
