package cn.com.duiba.oto.dto.oto.cust;

import lombok.Data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2022/10/13 13:55
 * @Description:
 */
@Data
public class OtoEsInviteCustDto implements Serializable {

    private static final long serialVersionUID = -5084176949564448536L;
    /**
     * 主键
     */
    private Long id;

    /**
     * 标签id
     */
    private List<Long> tagIds = new ArrayList<>(1);

    /**
     * 客户手机号（包括）
     */
    private List<String> phones;

    /**
     * 当前跟进邀约人id
     */
    private Long inviteId;

    /**
     * 销售Id
     */
    private Long sellerId;

    /**
     * 专家Id
     */
    private Long expertId;

    /**
     * 客户所处资源池类型
     *
     * @see cn.com.duiba.oto.enums.cust.OtoCustPoolEnum
     */
    private Integer poolType;

    /**
     * 客户名称
     */
    private String custName;

    /**
     * 客户年龄
     */
    private Integer custAge;

    /**
     * 客户等级
     */
    private Integer custLevel;

    /**
     * 是否重点跟进
     */
    private Integer custStar = 0;

    /**
     * 是否高质量用户
     */
    private Integer inviteStar = 0;

    /**
     * 是否社区高客
     */
    private Integer communityStar = 0;

    /**
     * 承接时间
     */
    private String assignTime;

    /**
     * 联系次数
     */
    private Integer callTimes = 0;

    /**
     * 最近联系时间
     */
    private String lastCallTime;

    /**
     * 客户来源（初次）
     *
     * @see cn.com.duiba.oto.enums.cust.CustFromSourceEnum
     */
    private String custFromSourceFrist;

    /**
     * 客户来源（最后一次）
     *
     * @see cn.com.duiba.oto.enums.cust.CustFromSourceEnum
     */
    private String custFromSourceLast;

    /**
     * 是否标记成单 0否 1是
     */
    private Integer dealFlag = 0;

    /**
     * 最初创建时间
     */
    private String gmtCreateTime;

    /**
     * 最近激活时间
     */
    private String lastGmtCreateTime;

    /**
     * 账户ID集合
     */
    private List<String> launchAccountIds;

    /**
     * 广告组名称
     */
    private String adgroupName;

    /**
     * 加微状态
     */
    private Integer addWxStatus;

    /**
     * 是否约到一面 0否 1是
     */
    private Integer firstInterviewFlag;

    /**
     * 是否呼出（当前邀约）
     */
    private Integer callOut;

    /**
     * 是否接通（当前邀约）
     */
    private Integer callConnect;

    /**
     * 是否应邀（当前邀约）
     */
    private Integer custInvite;

    /**
     * 是否到场（当前邀约）
     */
    private Integer custPresent;

    /**
     * 是否鸽子（当前邀约）
     */
    private Integer custDove;
}
