package cn.com.duiba.oto.dto.oto.interview;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

@Data
public class InterviewBoardListDto implements Serializable {
    private static final long serialVersionUID = 4011617160188918337L;

    /**
     * 面访id
     */
    private Long id;

    /**
     * 提报时间
     */
    private Date submitTime;

    /**
     * 专家id
     */
    private Long sellerId;

    /**
     * 专家姓名
     */
    private String sellerName;

    /**
     * 客户id
     */
    private Long custId;

    /**
     * 客户名字
     */
    private String custName;

    /**
     * 见面时间
     */
    private Date interviewTime;


    /**
     * 见面场景
     */
    private String interviewSceneConfDesc;


    /**
     * 客户入库时间
     */
    private Date createTime;


    /**
     * 客户来源
     */
    private String custSource;

    /**
     * 面访状态：{@link cn.com.duiba.oto.enums.OtoCustInterviewStatusEnum}
     */
    private Integer interviewStatus;

    /**
     * 此次面访以前，最近一次入库时间
     */
    private Date lastCreateTime;

    /**
     * 此次面访以前，最近一次入库的来源
     */
    private String lastCustFromSource;

    /**
     * 最近一次面访之前的最后一次面访时间
     */
    private Date lastInterviewTimeBeforeLastCreate;

    /**
     * 最近一次该销售的分配时间
     */
    private Date sellerAssignTime;
}
