package cn.com.duiba.oto.enums.cust;

import javafx.util.Pair;

import java.util.Arrays;
import java.util.List;

/**
 * @author xiaotian
 * @date 2022/10/11 2:34 PM
 */
public enum CustParamKeyFactory {
    /**
     * 添加新key的时候确保不要跟之前的重复！！！！！！！！！！！！
     */
    OTO00001("headImage", "客户头像"),
    OTO00002("considerAgedForWho", "为谁考虑养老"),
    OTO00003("attentionOldCommunity", "最关注养老社区什么"),
    OTO00004("talkForNext", "下次见面聊什么"),
    OTO00005("nextMeetTime", "下次见面时间"),
    OTO00006("finishPlanFlag", "是否定稿计划书"),
    OTO00007("insuranceDemand", "保险需求"),
    OTO00008("insuranceProducts", "做什么产品"),
    OTO00009("insured", "投/被保人"),
    OTO00010("insuranceAmount", "保险金额是多少"),
    OTO00011("drawType", "支取方案"),
    OTO00012("familyStructure", "家庭结构"),
    OTO00013("familyTies", "家庭关系"),
    OTO00014("occupationAndPension", "职业及退休金情况"),
    OTO00015("financialHabits", "平时理财习惯"),
    OTO00016("workingCapital", "手上有多少流动资金（大概）"),
    OTO00017("checkInCommunity", "是否需要入住社区"),
    OTO00018("otherDetails", "其它细节"),
    OTO00019("commitPlanFlag", "是否讲解计划书"),
    OTO00020("custManner", "客户态度"),
    OTO00021("rejectReason", "拒绝原因"),
    OTO00022("chanceReason", "机会原因"),
    OTO00023("inviteNextConnectTime", "下次联系日期"),
    OTO00024("doveDate", "鸽子时间"),
    OTO00025("rejectDate", "拒绝时间"),
    OTO00026("backDate", "退回时间"),
    OTO00027("viewRetireCommunity", "养老社区参观情况"),
    OTO00028("reCollectionCust", "未接通电话次数"),
    OTO00029("firstInterviewFlag", "约到情况"),
    OTO00030("cdf_guaranteeSlipNo", "保单号"),
    OTO00031("cdf_supplierId", "保险公司ID"),
    OTO00032("cdf_productId", "险种ID"),
    OTO00033("cdf_sellerId", "销售ID"),
    OTO00034("cdf_expertId", "专家ID"),
    OTO00035("cdf_writtenPremium", "签单保费"),
    OTO00036("cdf_costOption", "缴费年期"),
    OTO00037("cdf_standardInsurance", "承保年化标保"),
    OTO00038("cdf_insuranceAmount", "保险金额"),
    OTO00039("cdf_insureTime", "投保日期"),
    OTO00040("cdf_comeIntoFaceTime", "生效日期"),
    OTO00041("cdf_applicantName", "投保人"),
    OTO00042("cdf_insuredName", "被保人"),
    OTO00043("cdf_insuranceYearStandard", "承包年化标保"),
    OTO00044("expert_sign", "客户专家服务报名标识"),
    OTO00045("cust_equity_level", "客户会员等级"),
    OTO00046("cust_equity_integral", "客户积分"),
    OTO00047("risk_cust_base", "风险报告-基础信息"),
    OTO00048("risk_cust_financial", "风险报告-金融资产情况"),
    OTO00049("risk_cust_immovables", "风险报告-不动产权"),
    OTO00050("risk_cust_family", "风险报告-家庭拓扑图"),
    OTO00051("risk_cust_family_image", "风险报告-家庭拓扑图图片"),
    OTO00052("risk_cust_time", "风险报告-阶段时间"),
    OTO00053("cust_equity_name", "权益名称"),
    OTO00054("risk_cust_insurance", "养老金收益"),
    OTO00055("risk_cust_bankfinancing", "银行理财收益"),
    OTO00056("service_card_year_contract", "服务年卡合同"),
    OTO00057("service_card_forever_contract", "服务永久卡合同"),
    OTO00058("cust_star", "重点客户标记"),
    OTO00059("invite_star", "邀约标记高质量客户"),
    OTO00060("community_star", "社区高客标记"),
    OTO00061("separate_read", "脱落查看"),
    ;

    private static final String SPACE = "oto";
    private static final String SEPARATOR = "_";

    String key;

    String desc;

    CustParamKeyFactory(String key, String desc) {
        this.desc = desc;
        this.key = key;
    }

    public static List<String> getAllNewParam() {
        return Arrays.asList(CustParamKeyFactory.OTO00002.toString(),
                CustParamKeyFactory.OTO00003.toString(),
                CustParamKeyFactory.OTO00004.toString(),
                CustParamKeyFactory.OTO00005.toString(),
                CustParamKeyFactory.OTO00006.toString(),
                CustParamKeyFactory.OTO00007.toString(),
                CustParamKeyFactory.OTO00008.toString(),
                CustParamKeyFactory.OTO00009.toString(),
                CustParamKeyFactory.OTO00010.toString(),
                CustParamKeyFactory.OTO00011.toString(),
                CustParamKeyFactory.OTO00012.toString(),
                CustParamKeyFactory.OTO00013.toString(),
                CustParamKeyFactory.OTO00014.toString(),
                CustParamKeyFactory.OTO00015.toString(),
                CustParamKeyFactory.OTO00016.toString(),
                CustParamKeyFactory.OTO00017.toString(),
                CustParamKeyFactory.OTO00018.toString(),
                CustParamKeyFactory.OTO00019.toString(),
                CustParamKeyFactory.OTO00027.toString());
    }

    /**
     * 客户资料表单key
     *
     * @param fromId
     * @param questionId
     * @return
     */
    public static String custFormKey(Long fromId, Long questionId) {
        return "cust" + SEPARATOR + fromId + SEPARATOR + questionId;
    }

    /**
     * 客户资料表单key获取具体表单id和问题id
     *
     * @param key
     * @return
     */
    public static Pair<Long, Long> get(String key) {
        String[] split = key.split(SEPARATOR);
        if (split.length != 3) {
            return null;
        }
        try {
            return new Pair<>(Long.parseLong(split[1]), Long.parseLong(split[2]));
        } catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    public String toString() {
        return SPACE + SEPARATOR + this.key;
    }
}
