package cn.com.duiba.oto.dto.oto.rights;

import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * 功能描述：
 *
 * @Auther: xiaotian
 * @Date: 2023/11/16 17:07
 * @Description:
 */
@Data
public class CustomerRightsDto implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 主键
     */
    private Long id;
    /**
     * 客户id
     */
    private Long custId;
    /**
     * 权益包id: tb_oto_rights_package.id
     */
    private Long packageId;
    /**
     * 权益id: tb_oto_rights_config.id
     */
    private Long rightsId;
    /**
     * 权益信息
     */
    private String rightDetail;
    /**
     * 创建时间
     */
    private Date gmtCreate;
    /**
     * 修改时间
     */
    private Date gmtModified;


    @Data
    public static class RightDetailParamDto implements Serializable {
        private static final long serialVersionUID = -371869346044777434L;
        /**
         * 发放次数
         */
        private Integer allTimes;
        /**
         * 剩余次数
         */
        private Integer times;
        /**
         * 天数
         */
        private Integer days;
        /**
         * 期限服务激活后的到期时间
         */
        private Date durationEndTime;

        /**
         * 百分比
         */
        private Integer percent;
    }
}
