package cn.com.duiba.oto.enums.cust.follow;

import cn.com.duiba.kjy.base.api.utils.NumberUtil;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @author xiaotian
 * @version 1.0
 * @date 2022-01-25 09:54
 * 关注度枚举
 */
@Getter
@AllArgsConstructor
public enum OtoCustFollowWeightEnum {

    A(1, "A","三星"),
    B(2, "B","二星"),
    C(3, "C","一星"),
    ;

    /**
     * 通知类型
     */
    private final Integer type;

    /**
     * 备注
     */
    private final String desc;

    /**
     * 星级
     */
    private final String starLevel;

    private static final Map<Integer, String> TYPE_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustFollowWeightEnum::getType, OtoCustFollowWeightEnum::getDesc)));

    private static final Map<Integer, String> STAR_LEVEL_MAP = Collections.unmodifiableMap(Arrays.stream(values()).collect(Collectors.toMap(OtoCustFollowWeightEnum::getType, OtoCustFollowWeightEnum::getStarLevel)));

    /**
     * 根据类型获取备注
     */
    public static String getDescByType(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return null;
        }
        return TYPE_MAP.get(type);
    }

    /**
     * 根据类型获取星级
     * @param type 类型
     * @return 星级
     */
    public static String getStarLevelByType(Integer type){
        if (NumberUtil.isNullOrLteZero(type)) {
            return null;
        }
        return STAR_LEVEL_MAP.get(type);
    }

    /**
     * 根据类型获取备注
     */
    public static boolean contains(Integer type) {
        if (NumberUtil.isNullOrLteZero(type)) {
            return false;
        }
        return TYPE_MAP.containsKey(type);
    }
}
